/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#define DSP_CNTL_TIMER3		*(ioport  unsigned short*)0x3000
#define DSP_LOAD_TIMER3_LO	*(ioport  unsigned short*)0x3003
#define DSP_LOAD_TIMER3_HI	*(ioport  unsigned short*)0x3002
#define DSP_READ_TIMER3_LO	*(ioport  unsigned short*)0x3005
#define DSP_READ_TIMER3_HI	*(ioport  unsigned short*)0x3004

void    configure_timer();
long    read_time();
void    init_timer();
void    start_global_timer();
unsigned long read_counter();
void    stop_bitstreamreadheaders_timer();

struct ts
{
    long    current;
    long global;
    long    overall;
    long    idct;
    long    iquant;
    long    comp;
    long    edges;
    long    conv;
    long    trans;
    long    prediction;
    long    coding;
    long    get_mv_time;
    long    dma_in;
    long    dma_in_1;
    long    dma_in_2;
    long    dma_in_3;
    long    dma_in_4;
    long    dma_in_5;
    long    dma_in_6;
    long    dma_in_7;
    long    dma_in_8;
    long    dma_in_9;
    long    dma_out;            //copy out
    long    bitstreamtime;
    long    copy_bitstrem_in;
    long    decode_mbinter_time;
};

// set everything to zero //
